//+------------------------------------------------------------------+
//|                         !2TF Color Stochastic with Direction.mq4 |
//|                      Copyright  2010, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2010, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"

#property indicator_separate_window
#property indicator_buffers 6
//#property indicator_minimum 1
//#property indicator_maximum 100
#property indicator_level1 20
#property indicator_level2 80
#property indicator_color1 Yellow
#property indicator_color2 Blue
#property indicator_color3 Red
#property indicator_color4 SeaGreen
#property indicator_color5 Blue
#property indicator_color6 Red
#property indicator_width1 4
#property indicator_width2 4
#property indicator_width3 4
#property indicator_width4 2
#property indicator_width5 2
#property indicator_width6 2


extern int xi_TF.1 = 60;
extern int xi_KPeriod.1 = 14;
extern int xi_DPeriod.1 = 3;
extern int xi_Slowing.1 = 3;
extern int xi_MA.1 = 3;
extern int xi_PF.1 = 1;

extern int xi_TF.2 = 240;
extern int xi_KPeriod.2 = 10;
extern int xi_DPeriod.2 = 3;
extern int xi_Slowing.2 = 3;
extern int xi_MA.2 = 3;
extern int xi_PF.2 = 1;

//extern bool xb_Alerts = true;
extern bool xb_MOM.Mid = true;
extern int xi_CCI = 8;
extern int xi_TMA = 56;

extern bool xb_Show.MTF.Sep = true;

extern color xc_Text = LightGray;
extern color xc_Up = Blue;
extern color xc_Down = Red;
extern string xs_Unique.Pfx = "!MTF Sep_";

double IB_K.1[];
double IB_Level.1[];
double IB_Up.1[];
double IB_Down.1[];
double IB_K.2[];
double IB_Level.2[];
double IB_Up.2[];
double IB_Down.2[];

datetime gdt_TF.1[], gdt_TF.2[];
datetime gdt_TF.1.LB, gdt_TF.2.LB;
string gs_Ind.Name;
int gi_Window;
string gs_TF.1, gs_TF.2;
datetime gdt_Last.Alert;
datetime gdt_Last.eMail;

bool gb_Alerts, gb_eMail;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- 
   IndicatorBuffers(6);
   SetIndexBuffer(0,IB_K.1);
   SetIndexStyle(0,DRAW_LINE,STYLE_SOLID);
   SetIndexBuffer(1,IB_Up.1);
   SetIndexStyle(1,DRAW_LINE,STYLE_SOLID);
   SetIndexBuffer(2,IB_Down.1);
   SetIndexStyle(2,DRAW_LINE,STYLE_SOLID);
   SetIndexBuffer(3,IB_K.2);
   SetIndexStyle(3,DRAW_LINE,STYLE_SOLID);
   SetIndexBuffer(4,IB_Up.2);
   SetIndexStyle(4,DRAW_LINE,STYLE_SOLID);
   SetIndexBuffer(5,IB_Down.2);
   SetIndexStyle(5,DRAW_LINE,STYLE_SOLID);
   
   SetIndexLabel(0,"TF 1");
   SetIndexLabel(1,"TF 1 Up");
   SetIndexLabel(2,"TF 1 Down");
   SetIndexLabel(3,"TF 2");
   SetIndexLabel(4,"TF 2 Up");
   SetIndexLabel(5,"TF 2 Down");
   
   IndicatorDigits(Digits);
   
   string ls_MA.1, ls_Price.1;
   string ls_MA.2, ls_Price.2;
   
   ls_MA.1 = MA_To_String(xi_MA.1);
   ls_MA.2 = MA_To_String(xi_MA.2);
   ls_Price.1 = PF_To_String(xi_PF.1);
   ls_Price.2 = PF_To_String(xi_PF.2);
   gs_TF.1 = TF_To_String(xi_TF.1);
   gs_TF.2 = TF_To_String(xi_TF.2);
   
   gs_Ind.Name = "Stoch " +
                 "(" + gs_TF.1 + "," + xi_KPeriod.1 + "," + xi_DPeriod.1 + "," +
                 xi_Slowing.1 + "," + ls_MA.1 + "," + ls_Price.1 + ")" + " " +
                 "(" + gs_TF.2 + "," + xi_KPeriod.2 + "," + xi_DPeriod.2 + "," + 
                 xi_Slowing.2 + "," + ls_MA.2 + "," + ls_Price.2 + ")";
   
   IndicatorShortName(gs_Ind.Name);
   
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   Delete_Period_Seperators();
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
//----
   int counted_bars=IndicatorCounted();
   int i,y,limit.1, limit.2;
   
   if(counted_bars<0) return(-1);
   
   gi_Window = WindowFind(gs_Ind.Name);   
   
   double ld_Alert = GlobalVariableGet("!Kevinator Alerts");
   if (GetLastError() == 4058)
      GlobalVariableSet("!Kevinator Alerts",0);
   
   if (ld_Alert != 0)
      gb_Alerts = true;
   else
      gb_Alerts = false;

   double ld_eMail = GlobalVariableGet("!Kevinator eMail");
   if (GetLastError() == 4058)
      GlobalVariableSet("!Kevinator eMail",0);
   
   if (ld_eMail != 0)
      gb_eMail = true;
   else
      gb_eMail = false;

   limit.1 = MathMax(Bars-counted_bars,xi_TF.1/Period());
   limit.2 = MathMax(Bars-counted_bars,xi_TF.2/Period());
   
   if (gdt_TF.1.LB != iTime(NULL,xi_TF.1,0))
      {
      gdt_TF.1.LB = iTime(NULL,xi_TF.1,0);
      ArrayCopySeries(gdt_TF.1,MODE_TIME,NULL,xi_TF.1);
      }
      
   if (gdt_TF.2.LB != iTime(NULL,xi_TF.2,0))
      {
      gdt_TF.2.LB = iTime(NULL,xi_TF.2,0);
      ArrayCopySeries(gdt_TF.2,MODE_TIME,NULL,xi_TF.2);
      }
   
   // Fill the internal stochastic buffers
   for (i=0, y=0; i<limit.1; i++)
      {
      if (Time[i] < gdt_TF.1[y]) 
         {
         y++;
         if (xb_Show.MTF.Sep)
            {
            ObjectCreate(xs_Unique.Pfx+Time[i],OBJ_VLINE,gi_Window,Time[i],0);
            ObjectSet(xs_Unique.Pfx+Time[i],OBJPROP_STYLE,STYLE_DOT);
            ObjectSet(xs_Unique.Pfx+Time[i],OBJPROP_COLOR,xc_Text);
            }
         }
      IB_K.1[i] = iStochastic(NULL,xi_TF.1,xi_KPeriod.1,xi_DPeriod.1,xi_Slowing.1,xi_MA.1,xi_PF.1,MODE_MAIN,y);
      }
   
   for (i=0, y=0; i<limit.2; i++)
      {
      if (Time[i] < gdt_TF.2[y]) 
         {
         y++;
         if (xb_Show.MTF.Sep)
            {
            ObjectCreate(xs_Unique.Pfx+Time[i],OBJ_VLINE,gi_Window,Time[i],0);
            ObjectSet(xs_Unique.Pfx+Time[i],OBJPROP_STYLE,STYLE_SOLID);
            ObjectSet(xs_Unique.Pfx+Time[i],OBJPROP_COLOR,xc_Text);
            }
         }
      IB_K.2[i] = iStochastic(NULL,xi_TF.2,xi_KPeriod.2,xi_DPeriod.2,xi_Slowing.2,xi_MA.2,xi_PF.2,MODE_MAIN,y);
      }
      
   // Fill the visual stochastic buffers   
   for (i=limit.1; i>=0; i--)
      {
      if (IB_K.1[i] > IB_K.1[i+1])
         {
         IB_Up.1[i] = IB_K.1[i];
         IB_Up.1[i+1] = IB_K.1[i+1];
         }
      else 
         {
         IB_Up.1[i] = EMPTY_VALUE;
         if (IB_Up.1[i+2] == EMPTY_VALUE)
            IB_Up.1[i+1] = EMPTY_VALUE;
         }
      if (IB_K.1[i] < IB_K.1[i+1])
         {
         IB_Down.1[i] = IB_K.1[i];
         IB_Down.1[i+1] = IB_K.1[i+1];
         }
      else 
         {
         IB_Down.1[i] = EMPTY_VALUE;
         if (IB_Down.1[i+2] == EMPTY_VALUE)
            IB_Down.1[i+1] = EMPTY_VALUE;
         }
      }
         
   for (i=limit.2; i>=0; i--)
      {
      if (IB_K.2[i] > IB_K.2[i+1])
         {
         IB_Up.2[i] = IB_K.2[i];
         IB_Up.2[i+1] = IB_K.2[i+1];
         }
      else 
         {
         IB_Up.2[i] = EMPTY_VALUE;
         if (IB_Up.2[i+2] == EMPTY_VALUE)
            IB_Up.2[i+1] = EMPTY_VALUE;
         }
      if (IB_K.2[i] < IB_K.2[i+1])
         {
         IB_Down.2[i] = IB_K.2[i];
         IB_Down.2[i+1] = IB_K.2[i+1];
         }
      else 
         {
         IB_Down.2[i] = EMPTY_VALUE;
         if (IB_Down.2[i+2] == EMPTY_VALUE)
            IB_Down.2[i+1] = EMPTY_VALUE;
         }
      }
         
   // Display the last stoch movements   
   bool lb_Up.1 = false;
   bool lb_Up.2 = false;
   // First TF
   for (i = 0; i<limit.1; i++)
      {
      if (IB_Up.1[i] != EMPTY_VALUE) break;
      if (IB_Down.1[i] != EMPTY_VALUE) break;
      }
   Object_Create("!2TFStoch.Desc.1",25,20,gs_TF.1,10,"Arial",xc_Text);
   if (IB_Up.1[i] != EMPTY_VALUE)
      {
      Object_Create("!2TFStoch.Dir.1",5,20,"Up",10,"Arial",xc_Up);
      lb_Up.1 = true;
      }
   else
      Object_Create("!2TFStoch.Dir.1",5,20,"Dn",10,"Arial",xc_Down);
      
   // Second TF
   for (i = 0; i<limit.2; i++)
      {
      if (IB_Up.2[i] != EMPTY_VALUE) break;
      if (IB_Down.2[i] != EMPTY_VALUE) break;
      }
   Object_Create("!2TFStoch.Desc.2",25,35,gs_TF.2,10,"Arial",xc_Text);
   if (IB_Up.2[i] != EMPTY_VALUE)
      {
      Object_Create("!2TFStoch.Dir.2",5,35,"Up",10,"Arial",xc_Up);
      lb_Up.2 = true;
      }
   else
      Object_Create("!2TFStoch.Dir.2",5,35,"Dn",10,"Arial",xc_Down);

   // Exit if no alerts to do
   if (!gb_Alerts && !gb_eMail) return(0);
   
   
   // Alerts are done on the current bar for speed
   
   double ld_TMA.Upper = iCustom(NULL,0,"TMA Called",xi_TMA,1,0);
   double ld_TMA.Lower = iCustom(NULL,0,"TMA Called",xi_TMA,2,0);
   double ld_TMA.Mid = iCustom(NULL,0,"TMA Called",xi_TMA,0,0);
   double ld_CCI.Now = iCCI(NULL,0,xi_CCI,PRICE_TYPICAL,0);
   double ld_CCI.Prv = iCCI(NULL,0,xi_CCI,PRICE_TYPICAL,1);
   
   // If momentum trades require the mid band at least
   if (xb_MOM.Mid)
      {
      ld_TMA.Upper = ld_TMA.Mid;
      ld_TMA.Lower = ld_TMA.Mid;
      }
            
   
   // Momentum trade
   // 2nd Stoch up/down price above/below outer lines
   if (lb_Up.2 && Bid < ld_TMA.Upper && 
       ld_CCI.Now > 0 && ld_CCI.Prv < 0)  // Bullish
      {
      if (gb_Alerts && gdt_Last.Alert != Time[0])
         {
         Alert(Symbol(),Period()," Possible Bullish momentum trade");
         gdt_Last.Alert = Time[0];
         }
      if (gb_eMail && gdt_Last.eMail != Time[0])
         {
         SendMail(Symbol()+Period()+" Possible Bullish momentum trade","See subject");
         gdt_Last.eMail = Time[0];
         }
      }
   
   if (!lb_Up.2 && Bid > ld_TMA.Lower && 
       ld_CCI.Now < 0 && ld_CCI.Prv > 0)  // Bearish
      {
      if (gb_Alerts && gdt_Last.Alert != Time[0])
         {
         Alert(Symbol(),Period()," Possible Bearish momentum trade");
         gdt_Last.Alert = Time[0];
         }
      if (gb_eMail && gdt_Last.eMail != Time[0])
         {
         SendMail(Symbol()+Period()+" Possible Bearish momentum trade","See subject");
         gdt_Last.eMail = Time[0];
         }
      }
      
   
   // Standard scalp trade
   // Hrly Stoch up/down price above/below mid line
   if (lb_Up.1 && Bid < ld_TMA.Mid &&
       ld_CCI.Now > 0 && ld_CCI.Prv < 0)  // Bullish
      {
      if (gb_Alerts && gdt_Last.Alert != Time[0])
         {
         Alert(Symbol(),Period()," Possible Bullish scalp trade");
         gdt_Last.Alert = Time[0];
         }
      if (gb_eMail && gdt_Last.eMail != Time[0])
         {
         SendMail(Symbol()+Period()+" Possible Bullish scalp trade","See subject");
         gdt_Last.eMail = Time[0];
         }
      }
   
   if (!lb_Up.1 && Bid > ld_TMA.Mid &&
       ld_CCI.Now < 0 && ld_CCI.Prv > 0)  // Bearish
      {
      if (gb_Alerts && gdt_Last.Alert != Time[0])
         {
         Alert(Symbol(),Period()," Possible Bearish scalp trade");
         gdt_Last.Alert = Time[0];
         }
      if (gb_eMail && gdt_Last.eMail != Time[0])
         {
         SendMail(Symbol()+Period()+" Possible Bearish scalp trade","See subject");
         gdt_Last.eMail = Time[0];
         }
      }

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| MA To String                                                     |
//+------------------------------------------------------------------+
string MA_To_String(int pi_MA)
  {
//----
   string ps_MA;
   
   switch(pi_MA)
      {
      case 0: ps_MA = "SMA";
              break;
      case 1: ps_MA = "EMA";
              break;
      case 2: ps_MA = "SMMA";
              break;
      case 3: ps_MA = "LWMA";
              break;
      default: ps_MA = "ERR";
               break;
      }
   
//----
   return(ps_MA);
  }
//+------------------------------------------------------------------+
//| TF To String                                                     |
//+------------------------------------------------------------------+
string TF_To_String(int pi_TF)
  {
//----
   string ps_TF;
   
   switch(pi_TF)
      {
      case 1: ps_TF = "1m";
              break;
      case 5: ps_TF = "5m";
              break;
      case 15: ps_TF = "15m";
               break;
      case 30: ps_TF = "30m";
               break;
      case 60: ps_TF = "1h";
               break;
      case 240: ps_TF = "4h";
                break;
      case 1440: ps_TF = "1d";
                 break;
      case 10080: ps_TF = "1w";
                  break;
      case 43200: ps_TF = "1mn";
                  break;
      default: ps_TF = "ERR";
               break;
      }
   
//----
   return(ps_TF);
  }
//+------------------------------------------------------------------+
//| PF To String                                                     |
//+------------------------------------------------------------------+
string PF_To_String(int pi_PF)
  {
//----
   string ps_PF;
   
   switch(pi_PF)
      {
      case 0: ps_PF = "H/L";
              break;
      case 1: ps_PF = "C/C";
              break;
      default: ps_PF = "ERR";
               break;
      }
   
//----
   return(ps_PF);
  }
//+------------------------------------------------------------------+
//| create screen objects                                            |
//+------------------------------------------------------------------+
void Object_Create(string ps_name,int pi_x,int pi_y,string ps_text=" ",int pi_size=12,
                  string ps_font="Arial",color pc_colour=CLR_NONE)
  {
//----
         
   ObjectCreate(ps_name,OBJ_LABEL,gi_Window,0,0,0,0);
   ObjectSet(ps_name,OBJPROP_CORNER,1);
   ObjectSet(ps_name,OBJPROP_COLOR,pc_colour);
   ObjectSet(ps_name,OBJPROP_XDISTANCE,pi_x);
   ObjectSet(ps_name,OBJPROP_YDISTANCE,pi_y);
   
   ObjectSetText(ps_name,ps_text,pi_size,ps_font,pc_colour);

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Delete Period Seperators                                         |
//+------------------------------------------------------------------+
void Delete_Period_Seperators()
  {
//----
   string ls_Obj.Name;
   for (int i=ObjectsTotal()-1; i>=0; i--)
      {
      ls_Obj.Name=ObjectName(i);
      if (StringFind(ls_Obj.Name,xs_Unique.Pfx)>-1) ObjectDelete(ls_Obj.Name);
      }
//----
   return(0);
  }
//+------------------------------------------------------------------+